
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Nov 29 19:51:53 2007
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_ATP_TST_AES_MAIN.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/* disabling pc lint warning regarding to constant condition :
   'Constant value Boolean' */
/*lint --e{506} */

/***** Include Files ******/
#include "CRYS.h"

#include "CRYS_ATP_TST_Defines.h"
#include "CRYS_ATP_TST_AES_Acceptance.h"
#include "CRYS_ATP_TST_UTIL_Funcs.h"

#include <stdio.h>
#include "DX_VOS_Mem.h"
#if TST_USE_AES_DATA /*In case no test vectors are selected - code disabled*/
/******** Defines ********/
/******** Enums **********/
/******** Typedefs *********/
/******** Global Data ********/
/***** Private function prototype ******/
CRYSError_t CRYS_ATP_TST_AES_Acceptance_ALL_TESTS(void);


/******** Public Functions *****/
void CRYS_ATP_TST_AES_main(void)
{
  DxUint8_t  Var;

  do
   {
     do
     {
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n\n\n--[ AES tests Menu ]---------------------------------"));
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [1] - Acceptance NON integrated        (ECB/CBC/CTR)"));
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [2] - Acceptance Integrated            (ECB/CBC/CTR)"));
         ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [3] - Acceptance NON integrated        (MAC)        "));
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [4] - Acceptance Integrated            (MAC)        "));
         ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [5] - Acceptance NON integrated        (MAC-XCBC/CMAC)"));
         ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [6] - Acceptance Integrated            (MAC-XCBC/CMAC)"));
         
               #if (TST_USE_AES_16BYTE_DATA|TST_USE_AES_32BYTE_DATA|TST_USE_AES_512BYTE_DATA)
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [7] - Acceptance Key Wrap Unwrap                    "));
               #endif
               #if TST_USE_SECRETKEY_TESTS
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [8] - Acceptance Secret key            (ECB/CBC)    "));
               #endif
               #if TST_USE_PREDEFINED_SECRETKEY_TESTS
               #if (TST_USE_AES_16BYTE_DATA|TST_USE_AES_32BYTE_DATA|TST_USE_AES_512BYTE_DATA)
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [9] - Acceptance Predefined Secret Key (ECB/CBC)    "));
               #endif
               #endif
         #ifndef CRYS_NO_AES_XTS_MODE_SUPPORT
         ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [A] - Acceptance NON integrated        (XTS)        "));
         ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [B] - Acceptance integrated    (XTS)              "));
         #endif
         #ifndef CRYS_NO_AESCCM_SUPPORT    
         ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [C]-  Acceptance NON integrated        (AES_CCM)   "));
         ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [D]-  Acceptance integrated            (AES_CCM)                        "));
         #endif 
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [T] - ALL AES Acceptance tests                      "));
         ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [Z] - End of tests return to prev menu         "));
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n-----------------------------------------------------\n\n"));
             scanf("\n%c",&Var);
             ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n Test = %c\n",Var));
             if (Var<='Z')
                      break;
             else
             {
                   ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n Error[%d]  Please select '1'-'XX'\n\n",Var));
             }

      }while(1);


      switch(Var)
      {
        case '1':
            CRYS_ATP_TST_AES_Acceptance_NON_integrated();
            break;
        case '2':
            CRYS_ATP_TST_AES_Acceptance_Integrated();
            break;
      case '3':
            CRYS_ATP_TST_AES_Acceptance_MAC_NON_integrated();
            break;
      case '4':
            CRYS_ATP_TST_AES_Acceptance_MAC_integrated();
            break;
      case '5':
            CRYS_ATP_TST_AES_Acceptance_XCBC_CMAC_NON_integrated();
            break;
      case '6':
            CRYS_ATP_TST_AES_Acceptance_XCBC_CMAC_integrated();
            break;
      case '7':
            CRYS_ATP_TST_AES_Acceptance_KeyWrapUnwarp();
            break;
            #if TST_USE_SECRETKEY_TESTS
      case '8':
            CRYS_ATP_TST_AES_Acceptance_SK();
            break;
            #endif
            #if TST_USE_PREDEFINED_SECRETKEY_TESTS
      case '9':
            CRYS_ATP_TST_AES_Predefined_SecretKey();
            break;
            #endif
      #ifndef CRYS_NO_AES_XTS_MODE_SUPPORT
      case 'A':
          CRYS_ATP_TST_AES_XTS_Acceptance_NON_integrated();
          break;
      case 'B':
          CRYS_ATP_TST_AES_XTS_Acceptance_Integrated();
          break;
        #endif
			#ifndef CRYS_NO_AESCCM_SUPPORT
			case 'C':
					CRYS_ATP_TST_AES_CCM_Acceptance_NON_integrated();
					break;
			case 'D':
					CRYS_ATP_TST_AES_CCM_Acceptance_Integrated();
					break;
		  	#endif
        case 'T':
            CRYS_ATP_TST_AES_Acceptance_ALL_TESTS();
            break;
           case 'Z':
                  ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n End of AES tests \n"));
                  break ;

           default:
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n* Error in test selection [%c]\n",Var));
      }
         if(Var =='Z')
         break;
     }while (1);
}


/******** Private Functions **********/
/***************************
 * Function Name:
 *   CRYS_ATP_TST_AES_Acceptance_ALL_TESTS
 *
 * Inputs:
 *   none
 *
 * Outputs:
 *   CRYSError_t - Function error return
 *
 * Description:
 * This function runs all of the AES Acceptance tests
 *
 **************************/
CRYSError_t CRYS_ATP_TST_AES_Acceptance_ALL_TESTS(void)
{
    CRYSError_t        TST_Status = TESTPASS ,TST_TestStatus = TESTPASS;
    DxUint8_t          TST_DebugStatus = ATP_EXIT_TEST_AFTER_FAILURE;  

    TST_TestStatus = CRYS_ATP_TST_AES_Acceptance_NON_integrated();
    TST_Status = TST_Status+TST_TestStatus;

    if (TST_DebugStatus == NO_DEBUG)
    {
      if (TST_Status != TESTPASS)
          goto EXIT_ON_ERROR;
    }


    TST_TestStatus = CRYS_ATP_TST_AES_Acceptance_Integrated();
    TST_Status = TST_Status+TST_TestStatus;

    if (TST_DebugStatus == NO_DEBUG)
    {
      if (TST_Status != TESTPASS)
         goto EXIT_ON_ERROR;
    }


    TST_TestStatus = CRYS_ATP_TST_AES_Acceptance_MAC_NON_integrated();
    TST_Status = TST_Status+TST_TestStatus;

    if (TST_DebugStatus == NO_DEBUG)
    {
      if (TST_Status != TESTPASS)
          goto EXIT_ON_ERROR;
    }


    TST_TestStatus = CRYS_ATP_TST_AES_Acceptance_MAC_integrated();
    TST_Status = TST_Status+TST_TestStatus;

    if (TST_DebugStatus == NO_DEBUG)
    {
      if (TST_Status != TESTPASS)
          goto EXIT_ON_ERROR;
    }


  TST_TestStatus = CRYS_ATP_TST_AES_Acceptance_XCBC_CMAC_NON_integrated();
    TST_Status = TST_Status+TST_TestStatus;

    if (TST_DebugStatus == NO_DEBUG)
    {
      if (TST_Status != TESTPASS)
          goto EXIT_ON_ERROR;
    }


  TST_TestStatus = CRYS_ATP_TST_AES_Acceptance_XCBC_CMAC_integrated();
    TST_Status = TST_Status+TST_TestStatus;

    if (TST_DebugStatus == NO_DEBUG)
    {
      if (TST_Status != TESTPASS)
          goto EXIT_ON_ERROR;
    }


    #if (TST_USE_AES_16BYTE_DATA|TST_USE_AES_32BYTE_DATA|TST_USE_AES_512BYTE_DATA)
    TST_TestStatus = CRYS_ATP_TST_AES_Acceptance_KeyWrapUnwarp();
    TST_Status = TST_Status+TST_TestStatus;

    if (TST_DebugStatus == NO_DEBUG)
    {
      if (TST_Status != TESTPASS)
          goto EXIT_ON_ERROR;
    }

    #endif

    #if TST_USE_SECRETKEY_TESTS
        TST_TestStatus = CRYS_ATP_TST_AES_Acceptance_SK();
        TST_Status = TST_Status+TST_TestStatus;

    if (TST_DebugStatus == NO_DEBUG)
    {
      if (TST_Status != TESTPASS)
          goto EXIT_ON_ERROR;
    }

    #endif
    #if TST_USE_PREDEFINED_SECRETKEY_TESTS
    #if (TST_USE_AES_16BYTE_DATA|TST_USE_AES_32BYTE_DATA|TST_USE_AES_512BYTE_DATA)
        TST_TestStatus = CRYS_ATP_TST_AES_Predefined_SecretKey();
        TST_Status = TST_Status+TST_TestStatus;

    if (TST_DebugStatus == NO_DEBUG)
    {
      if (TST_Status != TESTPASS)
          goto EXIT_ON_ERROR;
    }

    #endif
    #endif
    
    #ifndef CRYS_NO_AES_XTS_MODE_SUPPORT
    TST_TestStatus= CRYS_ATP_TST_AES_XTS_Acceptance_NON_integrated();
    TST_Status = TST_Status+TST_TestStatus;
    
    if (TST_DebugStatus == NO_DEBUG)
    {
      if (TST_Status != TESTPASS)
          goto EXIT_ON_ERROR;
    }

        
    TST_TestStatus = CRYS_ATP_TST_AES_XTS_Acceptance_Integrated();
    TST_Status = TST_Status+TST_TestStatus;
    
    if (TST_DebugStatus == NO_DEBUG)
    {
      if (TST_Status != TESTPASS)
          goto EXIT_ON_ERROR;
    }
    #ifndef CRYS_NO_AESCCM_SUPPORT
    	TST_TestStatus = CRYS_ATP_TST_AES_CCM_Acceptance_Integrated();
		TST_Status = TST_Status+TST_TestStatus;
     
		
		#if CRYS_ATP_TST_EXIT_SYS_TST_ON_ERROR
	        if (TST_Status != TESTPASS)
			        goto EXIT_ON_ERROR;
    	#endif
    	
    	TST_TestStatus = CRYS_ATP_TST_AES_CCM_Acceptance_NON_integrated();
		TST_Status = TST_Status+TST_TestStatus;
     
		
		#if CRYS_ATP_TST_EXIT_SYS_TST_ON_ERROR
	        if (TST_Status != TESTPASS)
			        goto EXIT_ON_ERROR;
    	#endif
    #endif

  #endif
        ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n \n**********************\n"));
        ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************\n"));
        ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*** ALL OF THE AES Acceptance TESTS PASS   :-)         ***\n"));
        ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************\n"));
        ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************\n"));

	    return TST_Status;
          
EXIT_ON_ERROR:
		{
        ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));
        ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!!!!!!! ONE OR MORE OF THE AES TESTS FAILED !!!!!!!!!!!!!!!!!!!!\n"));
        ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));

		return DX_FAILURE;
      }

    

}


#endif

